/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.ui.config;

import frc.emul.config.Configuration;
import frc.emul.util.swing.AALabel;
import frc.emul.util.swing.JSpinnerFix;
import frc.emul.vectrex.swing.UI;
import frc.emul.vectrex.ui.Borders;
import frc.emul.vectrex.ui.Timing;
import frc.emul.vectrex.ui.config.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIFrameRate {
    private JButton bSave;
    private SettingsHandler handler;
    private UI emulUI;
    private Window currentWin;
    private boolean autoApply;
    private JComboBox cbMethod;

    public boolean isOpened() {
        return this.currentWin != null && this.currentWin.isVisible();
    }

    private void apply() {
        if (this.handler != null) {
            this.handler.apply();
            if (this.bSave != null) {
                this.bSave.setEnabled(true);
            }
        } else {
            System.out.println("NO HANDLER AVAILABLE FOR TIMING !!!!");
        }
    }

    private void loadCurrentSettings(Timing timing, JComboBox jComboBox) {
        jComboBox.setSelectedIndex(timing.getMethod());
    }

    public synchronized void openSelector(Window window, final UI uI) {
        if (this.isOpened()) {
            this.currentWin.toFront();
            this.currentWin.requestFocus();
            return;
        }
        final JDialog jDialog = UIUtils.createDialog(window, "ParaJVE - FrameRate Settings", false);
        jDialog.setDefaultCloseOperation(2);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (UIFrameRate.this.currentWin == windowEvent.getWindow()) {
                    UIFrameRate.this.currentWin = null;
                }
            }
        });
        this.handler = null;
        this.currentWin = jDialog;
        this.emulUI = uI;
        JPanel jPanel = new JPanel(new FlowLayout(2, 0, 0));
        final JToggleButton jToggleButton = new JToggleButton("Auto-Apply");
        final JButton jButton = new JButton("Apply");
        JButton jButton2 = new JButton("Close");
        this.bSave = new JButton("Save");
        jPanel.add(this.bSave);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jToggleButton);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton);
        jPanel.add(Box.createHorizontalStrut(10));
        jPanel.add(jButton2);
        this.bSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIFrameRate.this.bSave.isEnabled()) {
                    UIFrameRate.this.bSave.setEnabled(false);
                    Configuration configuration = uI.getConfig();
                    uI.getTiming().store(configuration.timing);
                    configuration.save();
                }
            }
        });
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIFrameRate.this.autoApply = jToggleButton.isSelected();
                jButton.setEnabled(!UIFrameRate.this.autoApply);
                if (UIFrameRate.this.autoApply) {
                    UIFrameRate.this.apply();
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UIFrameRate.this.apply();
            }
        });
        UIUtils.registerEscapeButton(jButton2, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        if (this.autoApply) {
            jToggleButton.setSelected(true);
            jButton.setEnabled(false);
        }
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout(10, 10));
        container.add((Component)this.buildMainComp(), "Center");
        container.add((Component)jPanel, "South");
        UIUtils.setContainerBorder(container);
        this.bSave.setEnabled(false);
        jDialog.pack();
        UIUtils.center(jDialog, window, 0, 0);
        this.loadCurrentSettings(uI.getTiming(), this.cbMethod);
        jDialog.setResizable(false);
        jDialog.setVisible(true);
    }

    private JComponent buildMainComp() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        final JPanel jPanel3 = new JPanel(new BorderLayout(0, 0)){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                int n = Math.max(200, dimension.width);
                int n2 = Math.max(100, dimension.height);
                return new Dimension(n, n2);
            }
        };
        this.cbMethod = new JComboBox<String>(new String[]{" Fixed Frame Duration  --  preferred", " Fixed Wait Delay  --  not advised", " No Timing  --  for profiling / debuging"});
        this.cbMethod.setSelectedIndex(-1);
        this.cbMethod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = UIFrameRate.this.cbMethod.getSelectedIndex();
                jPanel3.setVisible(false);
                jPanel3.removeAll();
                boolean bl = UIFrameRate.this.autoApply;
                UIFrameRate.this.autoApply = false;
                try {
                    switch (n) {
                        case 0: {
                            UIFrameRate.this.handler = UIFrameRate.this.installFixedFpsControls(jPanel3);
                            break;
                        }
                        case 1: {
                            UIFrameRate.this.handler = UIFrameRate.this.installFixedDelayControls(jPanel3);
                            break;
                        }
                        case 2: {
                            UIFrameRate.this.handler = UIFrameRate.this.installNoTimingControls(jPanel3);
                        }
                    }
                    jPanel3.setVisible(true);
                }
                finally {
                    UIFrameRate.this.autoApply = bl;
                }
                if (UIFrameRate.this.autoApply) {
                    UIFrameRate.this.apply();
                }
            }
        });
        jPanel2.add((Component)new JLabel("Timing method"), "West");
        jPanel2.add((Component)this.cbMethod, "Center");
        jPanel3.setBorder(Borders.BEVEL_LOW_10);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    private SettingsHandler installFixedFpsControls(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new SpringLayout());
        final Timing timing = this.emulUI.getTiming();
        final JComboBox<String> jComboBox = new JComboBox<String>(new String[]{" NanoSeconds", " MilliSeconds"});
        final JLabel jLabel = new JLabel("");
        final JSlider jSlider = new JSlider(-1, 110, -1);
        jComboBox.setSelectedIndex(timing.isNanoResolution() ? 0 : 1);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (UIFrameRate.this.autoApply) {
                    UIFrameRate.this.apply();
                }
            }
        });
        jLabel.setToolTipText("FPS to achieve for a standard frame (30.000 CPU cycles)");
        jSlider.setToolTipText(jLabel.getToolTipText());
        jSlider.setMajorTickSpacing(10);
        jSlider.setPaintTicks(true);
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = jSlider.getValue();
                if (n <= 0) {
                    jSlider.setValue(1);
                } else {
                    jLabel.setText("Base FPS : " + n);
                    if (UIFrameRate.this.autoApply) {
                        UIFrameRate.this.apply();
                    }
                }
            }
        });
        jSlider.setValue(timing.getFPS());
        jSlider.setMinimum(0);
        jPanel2.add(new JLabel("Timing Resolution"));
        jPanel2.add(jComboBox);
        jPanel2.add(jLabel);
        jPanel2.add(jSlider);
        UIUtils.makeCompactGrid(jPanel2, 2, 2, 0, 0, 10, 6);
        jPanel.add((Component)jPanel2, "North");
        jComboBox.setToolTipText("<html><b></u>&nbsp;WARNING</u> :</b> NanoSeconds resolution may give random results on multi-core systems&nbsp;</html>");
        return new SettingsHandler(){

            public void apply() {
                timing.setFPS(jSlider.getValue(), jComboBox.getSelectedIndex() == 0);
                timing.setMethod(0);
            }
        };
    }

    private SettingsHandler installFixedDelayControls(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new BorderLayout(10, 10));
        final Timing timing = this.emulUI.getTiming();
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(timing.getMillisDelay(1.0f), 1.0, 2000.0, 1.0);
        JSpinnerFix jSpinnerFix = new JSpinnerFix(spinnerNumberModel){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height += 4;
                return dimension;
            }
        };
        jPanel2.add((Component)new JLabel("Delay to wait after each frame (ms)"), "West");
        jPanel2.add((Component)jSpinnerFix, "Center");
        jPanel2.add(Box.createVerticalGlue(), "South");
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (UIFrameRate.this.autoApply) {
                    UIFrameRate.this.apply();
                }
            }
        });
        jPanel.add((Component)jPanel2, "North");
        return new SettingsHandler(){

            public void apply() {
                timing.setMethod(1);
                timing.setMillisDelay(((Double)spinnerNumberModel.getValue()).longValue());
            }
        };
    }

    private SettingsHandler installNoTimingControls(JPanel jPanel) {
        jPanel.add((Component)new AALabel("<html><center><b><u>WARNING</b></u><br><br>With this setting, the emulation will go as fast as possible, but will look very choppy, eat 100% CPU, and is likely to be unplayable on fast computers.</html>"), "North");
        return new SettingsHandler(){

            public void apply() {
                UIFrameRate.this.emulUI.getTiming().setMethod(2);
            }
        };
    }

    private static interface SettingsHandler {
        public void apply();
    }
}

